from django.contrib import admin
from django.urls import path, include
from django.contrib.auth import views as auth_views
from django.conf.urls.static import static
from django.conf import settings

# import your new home & dashboard views
from .views import home, dashboard

urlpatterns = [
    path("admin/", admin.site.urls),
    # Auth
    path(
        "login/",
        auth_views.LoginView.as_view(template_name="auth/login.html"),
        name="login",
    ),
    path("logout/", auth_views.LogoutView.as_view(), name="logout"),
    # NEW Home + Dashboard
    path("", home, name="home"),
    path("dashboard/", dashboard, name="dashboard"),
    # Apps
    path("businesses/", include("businesses.urls", namespace="businesses")),
    path("bookkeeping/", include("bookkeeping.urls", namespace="bookkeeping")),
]

if settings.DEBUG:
    urlpatterns += static(settings.MEDIA_URL, document_root=settings.MEDIA_ROOT)
