from django.apps import AppConfig
from django.db.utils import OperationalError, ProgrammingError


class BookkeepingConfig(AppConfig):
    default_auto_field = "django.db.models.BigAutoField"
    name = "bookkeeping"

    def ready(self):
        from .models import Category

        # HMRC EXPENSES (from SA103F)
        default_expense_categories = [
            # HMRC SA103F Standard Categories
            "Advertising & Marketing",  # Box 29
            "Bank Charges",  # Box 30
            "Car/Vehicle Expenses",  # Box 20
            "Cost of Goods Sold",  # Box 17
            "Insurance",  # Box 25
            "Interest & Finance Charges",  # Box 30
            "Legal & Professional Fees",  # Box 27
            "Office Costs",  # Box 28
            "Other Business Expenses",  # Box 35
            "Premises Running Costs",  # Box 25
            "Repairs & Maintenance",  # Box 26
            "Staff Costs",  # Box 22
            "Subcontractor Costs",  # Box 22
            "Telephone, Mobile & Internet",  # Box 28
            "Travel & Subsistence",  # Box 20
            "Utilities",  # Box 25
            # Capital Allowances (Box 49–59)
            "Capital Allowances",
            "Computers & Laptops",
            "Tools & Equipment",
            "Plant & Machinery",
        ]

        # HMRC-INCOME CATEGORIES (SA103F-compliant)
        default_income_categories = [
            "Turnover - Sales",
            "Other Business Income",
            "Bank Interest",
        ]

        try:
            # Seed EXPENSE categories
            for name in default_expense_categories:
                Category.objects.get_or_create(
                    name=name,
                    category_type="expense",
                )

            # Seed INCOME categories
            for name in default_income_categories:
                Category.objects.get_or_create(
                    name=name,
                    category_type="income",
                )

        except (OperationalError, ProgrammingError):
            pass
