# bookkeeping/urls.py
from django.urls import path
from . import views

app_name = "bookkeeping"

urlpatterns = [
    path("income/", views.income_list, name="income_list"),
    path("income/add/", views.income_create, name="income_create"),
    path("income/<int:pk>/", views.income_detail, name="income_detail"),
    path("income/<int:pk>/edit/", views.income_edit, name="income_edit"),
    path("income/<int:pk>/delete/", views.income_delete, name="income_confirm_delete"),
    path("expense/", views.expense_list, name="expense_list"),
    path("expense/add/", views.expense_create, name="expense_create"),
    path("expense/<int:pk>/", views.expense_detail, name="expense_detail"),
    path("expense/<int:pk>/edit/", views.expense_edit, name="expense_edit"),
    path(
        "expense/<int:pk>/delete/", views.expense_delete, name="expense_confirm_delete"
    ),
    path("income/export/csv/", views.export_income_csv, name="income_export_csv"),
    path("expense/export/csv/", views.export_expense_csv, name="expense_export_csv"),
]
