"""
Launcher for MTDify Starter Edition.

- Lives in the same folder as:
  - manage.py
  - .env
  - db.sqlite3
  - templates/, static/, mtdify_starter/, businesses/, bookkeeping/
- Safe to use inside a PyInstaller EXE (handles _MEIPASS).
"""

import os
import sys
import threading
import time
import webbrowser
from pathlib import Path

from django.core.management import execute_from_command_line


def main():
    # Ensure we run from the folder where the EXE / script lives
    base_dir = Path(getattr(sys, "_MEIPASS", Path(__file__).resolve().parent))
    os.chdir(base_dir)

    # Point Django at the Starter settings
    os.environ.setdefault("DJANGO_SETTINGS_MODULE", "mtdify_starter.settings")

    url = "http://127.0.0.1:8000"

    def open_browser():
        time.sleep(1.5)
        try:
            webbrowser.open_new(url)
        except Exception:
            print(f"Please open your browser and go to: {url}")

    # Start browser opener in the background (one thread)
    threading.Thread(target=open_browser, daemon=True).start()

    # Start Django development server bound to localhost only
    # IMPORTANT: --noreload avoids the auto-reloader spawning a second process,
    # which is what caused multiple browser tabs in the past.
    execute_from_command_line(
        [
            "manage.py",
            "runserver",
            "127.0.0.1:8000",
            "--noreload",
        ]
    )


if __name__ == "__main__":
    main()
