from pathlib import Path
import environ

BASE_DIR = Path(__file__).resolve().parent.parent

# Initialise environ
env = environ.Env(DEBUG=(bool, True))

# Read .env file (Starter Edition)
env_file = BASE_DIR / ".env"
if env_file.exists():
    environ.Env.read_env(str(env_file))

# Default demo user (for local use only)
DEFAULT_USER_EMAIL = env("DEFAULT_USER_EMAIL", default="demo@example.com")
DEFAULT_USER_PASSWORD = env("DEFAULT_USER_PASSWORD", default="demo123")

# SECURITY
SECRET_KEY = env("SECRET_KEY", default="change-me-in-production")
DEBUG = env("DEBUG")

ALLOWED_HOSTS = env.list("ALLOWED_HOSTS", default=["*"])


# ==========================================================
# APPLICATIONS
# ==========================================================

INSTALLED_APPS = [
    "django.contrib.admin",
    "django.contrib.auth",
    "django.contrib.contenttypes",
    "django.contrib.sessions",
    "django.contrib.messages",
    "django.contrib.staticfiles",
    "django.contrib.humanize",
    "businesses",
    "bookkeeping",
]

AUTH_USER_MODEL = "businesses.User"

# =====================================================
# MIDDLEWARE
# ==============================================

MIDDLEWARE = [
    "django.middleware.security.SecurityMiddleware",
    "django.contrib.sessions.middleware.SessionMiddleware",
    "django.middleware.common.CommonMiddleware",
    "django.middleware.csrf.CsrfViewMiddleware",
    "django.contrib.auth.middleware.AuthenticationMiddleware",
    "django.contrib.messages.middleware.MessageMiddleware",
    "django.middleware.clickjacking.XFrameOptionsMiddleware",
]

# =======================================================
# URLS + WSGI
# =======================================================

ROOT_URLCONF = "mtdify_starter.urls"

TEMPLATES = [
    {
        "BACKEND": "django.template.backends.django.DjangoTemplates",
        "DIRS": [BASE_DIR / "templates"],
        "APP_DIRS": True,
        "OPTIONS": {
            "context_processors": [
                "django.template.context_processors.debug",
                "django.template.context_processors.request",
                "django.contrib.auth.context_processors.auth",
                "django.contrib.messages.context_processors.messages",
                "mtdify_starter.context_processors.version",
            ],
        },
    },
]

WSGI_APPLICATION = "mtdify_starter.wsgi.application"

# =======================================================
# DATABASE (SQLite)
# =======================================================

DATABASES = {
    "default": {
        "ENGINE": "django.db.backends.sqlite3",
        "NAME": BASE_DIR / "db.sqlite3",
    }
}

"""
# Optional PostgreSQL configuration
DATABASES = {
    "default": {
        "ENGINE": "django.db.backends.postgresql",
        "NAME": "mtdify_starter",
        "USER": "postgres",
        "PASSWORD": "",
        "HOST": "localhost",
        "PORT": "",
    }
}
"""

# ==========================================================
# PASSWORD VALIDATION
# ==========================================================

AUTH_PASSWORD_VALIDATORS = [
    {"NAME": "django.contrib.auth.password_validation.MinimumLengthValidator"},
]

# ==========================================================
# LOCALISATION
# ==========================================================

LANGUAGE_CODE = "en-gb"
TIME_ZONE = "Europe/London"
USE_I18N = True
USE_TZ = True

# ==========================================================
# STATIC
# ==========================================================

STATIC_URL = "/static/"
STATICFILES_DIRS = [BASE_DIR / "static"]
STATIC_ROOT = BASE_DIR / "staticfiles"

DEFAULT_AUTO_FIELD = "django.db.models.BigAutoField"


# ==========================================================
# LOGIN / LOGOUT
# ==========================================================

LOGIN_URL = "/login/"
LOGIN_REDIRECT_URL = "/dashboard/"
LOGOUT_REDIRECT_URL = "/login/"

# ==========================================================
# VERSION NUMBER AS OF 21 NOV 2025
# ==========================================================
MTDIFY_VERSION = "1.0.0"
