@echo off
echo ==========================================
echo   MTDify Starter Edition - Windows Launcher
echo ==========================================
echo.

REM Check for venv folder
IF EXIST "venv\Scripts\activate.bat" (
    echo Activating virtual environment...
    call venv\Scripts\activate.bat
) ELSE (
    echo No virtual environment found.
    echo Creating a new one...

    python -m venv venv
    call venv\Scripts\activate.bat

    echo Installing requirements...
    pip install -r requirements.txt
)

echo Running migrations...
python manage.py migrate

echo Creating default demo user (if needed)...
python manage.py create_default_user

echo Opening MTDify in your browser...
start "" http://127.0.0.1:8000

echo.
echo "=========================================="
echo "   MTDify Starter is now running"
echo "   Login with: demo@example.com / demo123"
echo "=========================================="
echo.

echo Starting MTDify Local on http://127.0.0.1:8000
python manage.py runserver
