#!/usr/bin/env bash
echo "=========================================="
echo "  MTDify Starter Edition - Linux/Mac Launcher"
echo "=========================================="
echo ""

# Check for venv
if [ -d "venv" ]; then
    echo "Activating virtual environment..."
    source venv/bin/activate
else
    echo "No virtual environment found."
    echo "Creating a new one..."
    python3 -m venv venv
    source venv/bin/activate

    echo "Installing requirements..."
    pip install -r requirements.txt
fi

echo "Running migrations..."
python3 manage.py migrate

echo Creating default demo user (if needed)...
python3 manage.py create_default_user

# Detect platform and open browser
URL="http://127.0.0.1:8000"
echo "Opening MTDify in your browser..."

if command -v xdg-open > /dev/null; then
    # Linux
    xdg-open "$URL"
elif command -v open > /dev/null; then
    # macOS
    open "$URL"
else
    echo "Could not detect browser auto-open tool. Please open: $URL"
fi

echo.
echo "=========================================="
echo "   MTDify Starter is now running"
echo "   Login with: demo@example.com / demo123"
echo "=========================================="
echo.

echo "Starting MTDify Local on $URL"
python3 manage.py runserver
